﻿// Procedure Loader Hide
#pragma TextEncoding = "UTF-8"
#pragma rtGlobals=3
#pragma hide=1

Static StrConstant k_panelName = "imgT_panel"
Static StrConstant k_fullpanel = "imgT_display#imgT_panel"

Function/S f_ProcTabOptions()

	string rstr
	rstr = "Remove Background;Apply Threshold;Mask Regions;"
	if (f_IsStack())
		rstr += "Stack Math;"
	else
		rstr += "\\M1(Stack Math;"	
	endif
	if (f_IsSplit())
		rstr += "Split Math;"
	else
		rstr += "\\M1(Split Math;"	
	endif
	if (f_HasMQ())
		rstr += "Crop to Marquee;"
	else
		rstr += "\\M1(Crop to Marquee;"
	endif
	return rstr
end

// ***
// FUNCTIONS

// draw tab2 - process
Function disp_Tab2Draw(pwidth, pheight, ptabpos)
	variable pwidth, pheight, ptabpos

	variable tvoffset = ptabpos + 30
	
	TabControl tab_main, value=2, userdata(ptab)="2"
	
	// Primary
	
	PopupMenu popupProcess_tab20,pos={12,tvoffset},size={100,23},title="How",fStyle=1,fSize=16,disable=1
	PopupMenu popupProcess_tab20,mode=1,value=#"f_ProcTabOptions()", proc=X_PopMenuProc

	disp_Tab21Draw(pwidth, pheight, ptabpos)		// remove background
	disp_Tab22Draw(pwidth, pheight, ptabpos)		// apply threshold
	disp_Tab23Draw(pwidth, pheight, ptabpos)		// mask regions
	disp_Tab24Draw(pwidth, pheight, ptabpos)		// stack math
	disp_Tab25Draw(pwidth, pheight, ptabpos)		// split math
	disp_Tab26Draw(pwidth, pheight, ptabpos)		// crop region
	
	return 0
end

// update tab Threshold
Function disp_updateTab2()

	variable method
	string tabList, ptab, udata
	
	ptab = "*_tab2*"
	tabList = ControlNameList(k_panelName,";",ptab)
	ModifyControlList tabList win=$k_fullpanel, disable=1
	ModifyControl popupProcess_tab20 win=$k_fullpanel, disable=0
	ControlInfo/W=$k_fullpanel popupProcess_tab20
	method = v_value
	
	switch(method)
		case 1:		// remove background
			ptab = "*_tab21"
			tabList = ControlNameList(k_panelName,";",ptab)
			ModifyControlList tabList win=$k_fullpanel, disable=0
			disp_updateTab21()
			break
		case 2:		// apply threshold
			ptab = "*_tab22"
			tabList = ControlNameList(k_panelName,";",ptab)
			ModifyControlList tabList win=$k_fullpanel, disable=0
			disp_updateTab22()
			break
		case 3:		// mask regions
			ptab = "*_tab23"
			tabList = ControlNameList(k_panelName,";",ptab)
			ModifyControlList tabList win=$k_fullpanel, disable=0
			disp_updateTab23()
			break
		case 4:		// stack math
			if (!f_IsStack())
				ptab = "*_tab21"
				tabList = ControlNameList(k_panelName,";",ptab)
				ModifyControlList tabList win=$k_fullpanel, disable=0
				disp_updateTab21()
				method = 1
			else
				ptab = "*_tab24"
				tabList = ControlNameList(k_panelName,";",ptab)
				ModifyControlList tabList win=$k_fullpanel, disable=0
				if (disp_updateTab24() < 0)
					ModifyControlList tabList win=$k_fullpanel, disable=1
					ptab = "*_tab21"
					tabList = ControlNameList(k_panelName,";",ptab)
					ModifyControlList tabList win=$k_fullpanel, disable=0
					disp_updateTab21()
					method = 1
				endif
			endif
			break
		case 5:		// split math
			if (!f_IsSplit())
				ptab = "*_tab21"
				tabList = ControlNameList(k_panelName,";",ptab)
				ModifyControlList tabList win=$k_fullpanel, disable=0
				disp_updateTab21()
				method = 1
			else
				ptab = "*_tab25"
				tabList = ControlNameList(k_panelName,";",ptab)
				ModifyControlList tabList win=$k_fullpanel, disable=0
				if (disp_updateTab25() < 0)
					ModifyControlList tabList win=$k_fullpanel, disable=1
					ptab = "*_tab21"
					tabList = ControlNameList(k_panelName,";",ptab)
					ModifyControlList tabList win=$k_fullpanel, disable=0
					disp_updateTab21()
					method = 1
				endif
			endif
			break
		case 6:		// crop
			if (!f_HasMQ())
				ptab = "*_tab21"
				tabList = ControlNameList(k_panelName,";",ptab)
				ModifyControlList tabList win=$k_fullpanel, disable=0
				disp_updateTab21()
				method = 1
				break
			endif
			ptab = "*_tab26"
			tabList = ControlNameList(k_panelName,";",ptab)
			ModifyControlList tabList win=$k_fullpanel, disable=0
			
			disp_updateTab26()
			break
	endswitch
	udata = StringFromList(method-1,f_ProcTabOptions())
	PopupMenu popupProcess_tab20, win=$k_fullpanel, mode=method, userdata=udata

	return 0
end